@extends('admin.layout.page-app')
@section('page_title', __('label.add_question'))
@section('tab_title', __('label.add_question'))

@section('content')
	@include('admin.layout.sidebar')

	<div class="right-content">
		@include('admin.layout.header')

		<div class="body-content">
			<!-- mobile title -->
			<h1 class="page-title-sm">{{__('label.add_question')}}</h1>

			<div class="border-bottom row">
				<div class="col-sm-10">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
						<li class="breadcrumb-item"><a href="{{ route('admin.fearfactorquestion.index') }}">{{__('label.questions')}}</a></li>
						<li class="breadcrumb-item active" aria-current="page">{{__('label.add_question')}}</li>
					</ol>
				</div>
				<div class="col-sm-2 d-flex align-items-center justify-content-end">
					<a href="{{ route('admin.fearfactorquestion.index') }}" class="btn btn-default mw-120" style="margin-top:-14px">{{__('label.questions')}}</a>
				</div>
			</div>

			<div class="card custom-border-card mt-3">
				<form id="save_question" enctype="multipart/form-data">
					<input type="hidden" name="id" value="">
					<div class="form-row">
						<div class="col-md-9">
							<div class="form-row">
								<!-- Category -->
								@if (!empty($quiz_configuration) && $quiz_configuration['category_status'] == 1)
									<div class="col-md-3">
										<div class="form-group">
											<label>{{__('label.category')}}<span class="text-danger">*</span></label>
											<select class="form-control" name="category_id">
												<option value="">{{__('label.select_category')}}</option>
												@foreach ($category as $key => $value)
													<option value="{{ $value['id'] }}">{{ $value['name'] }}</option>
												@endforeach  
											</select>
										</div>
									</div>
								@endif
								<!-- Skill -->
								@if (!empty($quiz_configuration) && $quiz_configuration['skill_status'] == 1)
									<div class="col-md-3">
										<div class="form-group">
											<label>{{__('label.skill')}}<span class="text-danger">*</span></label>
											<select class="form-control" name="skill_id">
												<option value="">{{__('label.select_skill')}}</option>
												@foreach ($skill as $key => $value)
													<option value="{{ $value['id'] }}">{{ $value['name'] }}</option>
												@endforeach  
											</select>
										</div>
									</div>
								@endif
								<!-- Classification -->
								@if (!empty($quiz_configuration) && $quiz_configuration['classification_status'] == 1)
									<div class="col-md-3">
										<div class="form-group">
											<label>{{__('label.classification')}}<span class="text-danger">*</span></label>
											<select class="form-control" name="classification_id">
												<option value="">{{__('label.select_classification')}}</option>
												@foreach ($classification as $key => $value)
													<option value="{{ $value['id'] }}">{{ $value['name'] }}</option>
												@endforeach  
											</select>
										</div>
									</div>
								@endif
								<!-- Level -->
								@if (!empty($quiz_configuration) && $quiz_configuration['level_status'] == 1)
									<div class="col-md-3">
										<div class="form-group">
											<label>{{__('label.level')}}<span class="text-danger">*</span></label>
											<select class="form-control" name="level_id">
												<option value="">{{__('label.select_level')}}</option>
												@foreach ($level as $key => $value)
													<option value="{{ $value['id'] }}">{{ $value['name'] }}</option>
												@endforeach  
											</select>
										</div>
									</div>
								@endif
							</div>
							<div class="form-row">
								<div class="col-md-12">
									<div class="form-group">
										<label>{{__('label.question')}}<span class="text-danger">*</span></label>
										<textarea class="form-control" name="question" rows="1" placeholder="{{__('label.question_here')}}"></textarea>
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('label.option_a')}}<span class="text-danger">*</span></label>
										<input type="text" name="option_a" class="form-control" placeholder="{{__('label.option_a_here')}}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('label.option_b')}}<span class="text-danger">*</span></label>
										<input type="text" name="option_b" class="form-control" placeholder="{{__('label.option_b_here')}}">
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('label.option_c')}}<span class="text-danger">*</span></label>
										<input type="text" name="option_c" class="form-control" placeholder="{{__('label.option_c_here')}}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group">
										<label>{{__('label.option_d')}}<span class="text-danger">*</span></label>
										<input type="text" name="option_d" class="form-control" placeholder="{{__('label.option_d_here')}}">
									</div>
								</div>
							</div>
							<div class="form-row">
								<div class="col-md-3">
									<div class="form-group">
										<label>{{__('label.correct_answer')}}<span class="text-danger">*</span></label>
										<select name="correct_answer" class="form-control">
											<option value="">{{__('label.select_answer')}}</option>
											<option value="1">{{__('label.a')}}</option>
											<option value="2">{{__('label.b')}}</option>
											<option value="3">{{__('label.c')}}</option>
											<option value="4">{{__('label.d')}}</option>
										</select>
									</div>
								</div>
								<div class="col-md-9">
									<div class="form-group">
										<label>{{__('label.note')}} <small>{{__('label.this_will_be_showing_with_review_section_only')}}</small></label>
										<textarea class="form-control" name="note" rows="1" placeholder="{{__('label.note_here')}}"></textarea>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-3">
							<div class="form-group ml-5">
								<label>{{__('label.image')}}</label>
								<div class="avatar-upload">
									<div class="avatar-edit">
										<input type='file' name="image" id="imageUpload1" accept=".png, .jpg, .jpeg" />
										<label for="imageUpload1" title="{{__('label.upload_file')}}"></label>
									</div>
									<div class="avatar-preview">
										<img src="{{ asset('assets/imgs/upload_img.png') }}" id="imagePreview1">
									</div>
								</div>
								<label class="mt-3 text-gray">{{__('label.max_size_5mb')}}</label>
							</div>
						</div>
					</div>
					<div class="border-top pt-3 text-right">
						<button type="button" class="btn btn-default mw-120" onclick="save_question()">{{__('label.save')}}</button>
						<a href="{{ route('admin.fearfactorquestion.index') }}" class="btn btn-cancel mw-120 ml-2">{{__('label.cancel')}}</a>
						<input type="hidden" name="_token" value="{{ csrf_token() }}">
					</div>
				</form>
			</div>
		</div>
	</div>
@endsection

@section('pagescript')
	<script>
		function save_question(){

			var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

				$("#dvloader").show();
				var formData = new FormData($("#save_question")[0]);
				$.ajax({
					type:'POST',
					url:'{{ route("admin.fearfactorquestion.store") }}',
					data:formData,
					cache:false,
					contentType: false,
					processData: false,
					success:function(resp){
						$("#dvloader").hide();
						get_responce_message(resp, 'save_question', '{{ route("admin.fearfactorquestion.index") }}');
					},
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
				});
			} else {
                showError();
            }
		}
	</script>
@endsection